<?php
// Counter logic
$counterFile = 'counter.txt'; // File to store visit count

// Initialize counter if file doesn't exist
if (!file_exists($counterFile)) {
    file_put_contents($counterFile, 0);
}

// Increment visit count
$count = (int)file_get_contents($counterFile);
$count++;
file_put_contents($counterFile, $count);

// Get the IP address from the URL if it exists
$ipToCheck = isset($_GET['ip']) ? $_GET['ip'] : '';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, viewport-fit=cover">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-title" content="MY IP">
    <link rel="apple-touch-icon" sizes="180x180" href="apple-touch-icon.png">
    <meta name="theme-color" content="#001">
    <title>IP Information</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto+Mono:ital,wght@0,100..700;1,100..700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
    <style>
        body {
            background-color: #001;
            color: #00bbda;
            font-family: 'Roboto Mono', sans-serif;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 85vh;
            flex-direction: column;
        }
        .container {
            width: 100%;
            text-align: center;
        }
        p {
            font-size: 1.4rem;
            margin: 5px 0;
            word-break: break-all;
        }
        a {
            color: #00dab1;
            text-decoration: none;
        }
        a:hover {
            text-decoration: none;
        }
        button {
            font-family: 'Roboto Mono', sans-serif;
        }
        .ipinfo {
            display: block;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            text-transform: uppercase;
            background-color: #00000040;
            z-index: 999;
            padding: 6px;
            border-radius: 5px;
            width: max-content;
            max-width: 90%;
            font-size: 1.5em;
        }
        #map {
            width: 100%;
            height: 70vh;
            border: 0px solid #000000;
            margin: auto;
            margin-top: -50px;
            opacity: 0.8;
            box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.8);
            -webkit-mask: linear-gradient(355deg, rgba(0,0,0,0) 10%, rgb(0, 0, 0) 50%);
            mix-blend-mode: screen;
            background-color: #001;
        }
        .ip-input {
            margin-top: 0px;
            margin-bottom:5vh;
        }
        .ip-input input {
            font-family: 'Roboto Mono', sans-serif;
            padding: 10px;
            border: none;
            border-radius: 5px;
            width: 200px;
            background-color: #002;
            color: #fff;
        }
        .ip-input button {
            padding: 10px;
            border: none;
            border-radius: 5px;
            background-color: #002cda;
            color: white;
            cursor: pointer;
            margin-left: 1px;
            transition: 0.3s;
        }
        .ip-input button:hover {
            background-color: #00137b;
        }
        .ip-input button:active {
            background-color: #44227b;
        }
    </style>
</head>
<body>
    <div class="container" id="info">
        <img src="loading.svg" width="180px" alt="loading"/>
    </div>
    <div class="ip-input">
        <input type="text" id="ipAddress" placeholder="Enter IP Address" title="Please enter a valid IP address (e.g., 192.168.1.1 or ::1)" />
        <button onclick="checkIP()" title="Click to Check IP Info">Check</button>
    </div>
    <p style="font-size:8px;color:#fff;opacity:0.2;cursor:default">Total Visits: <?php echo $count; ?></p>
    <p style="font-size:8px;color:#fff;opacity:0.5;display: block;top: 5px;position: absolute;cursor:default;left: 10px;background-color: #00000040;z-index:9999">©2025 neotechz.de</p>
    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
    <script>
        // Function to fetch and display IP information
        function fetchIPInfo(ip) {
            const apiUrl = `https://api.ipapi.is?q=${ip}`;
            fetch(apiUrl)
                .then(response => response.json())
                .then(data => {
                    if (data.ip) {
                        const ip = data.ip;
                        const country = data.location.country;
                        const city = data.location.city || 'Unknown';
                        const orgName = data.asn.org; 
                        const ipType = data.company.type; 
                        const countryCode = data.location.country_code;
                        const latitude = data.location.latitude;
                        const longitude = data.location.longitude;
                        const timezone = data.location.timezone;

                        // Generate flag emoji from country code
                        const flagEmoji = String.fromCodePoint(...[...countryCode].map(c => 0x1F1E6 + c.charCodeAt(0) - 65));

                        // Function to get current time in the city's timezone
                        const getCurrentTime = (timezone) => {
                            const options = { timeZone: timezone, hour: '2-digit', minute: '2-digit' };
                            return new Intl.DateTimeFormat([], options).format(new Date());
                        };

                        const currentTime = getCurrentTime(timezone);

                        const info = `
                            <div id="map"></div>
                            <p class="ipinfo" title="IP address">${ip}</p>
                            <p>
                                <a style="font-size:14px;color:#fff" href="https://www.google.com/maps/search/?api=1&query=${encodeURIComponent(country)}" target="_blank" title="IP Country - Map of ${country}">${flagEmoji} ${country}, </a> 
                                <a style="font-size:12px;color:#fff" href="https://www.google.com/maps/search/?api=1&query=${encodeURIComponent(city)}" target="_blank" title="IP City - Map of ${city}">${city}</a> 
                                <br>
                                <span style="font-size:10px;color:#fff;" title="Organization Name, IP TYPE">${orgName} (${ipType})</span> 
                                <br>
                                <p style="font-size:9px;color:#fff; text-transform: uppercase;" title="IP Local-Time">Local-time: ${currentTime}</p> 
                            </p><br>
                        `;
                        document.getElementById('info').innerHTML = info;

                        // Initialize the Leaflet map
                        const map = L.map('map', {
                            zoom: 12,
                            center: [latitude, longitude],
                            zoomControl: false
                        });

                        // Add dark-themed tile layer
                        L.tileLayer('https://{s}.basemaps.cartocdn.com/dark_all/{z}/{x}/{y}{r}.png', {
                            maxZoom: 19,
                            attribution: ''
                        }).addTo(map);

                        // Add a marker for the city
                        L.marker([latitude, longitude]).addTo(map);
                    } else {
                        document.getElementById('info').innerHTML = '<p>Unable to fetch data.</p>';
                    }
                })
                .catch(error => {
                    console.error('Error fetching data:', error);
                    document.getElementById('info').innerHTML = '<p>NO DATA FOR THIS IP! <br>Page reloads in 3 Seconds...</p>';
                    // Refresh the page after a short delay (e.g., 3 seconds)
                    setTimeout(() => {
                        location.reload();
                    }, 3000); // 3000 milliseconds = 3 seconds
                });
        }

        // Fetch the visitor's IP information when the page loads, if no IP is provided
        fetchIPInfo('<?php echo htmlspecialchars($ipToCheck); ?>');

        // Function to check IP
        function checkIP() {
            const ipAddress = document.getElementById('ipAddress').value.trim();
            const validIPv4 = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\.|$)){3}$/;
            const validIPv6 = /^([0-9a-fA-F]{1,4}:){7}([0-9a-fA-F]{1,4}|:)|::([0-9a-fA-F]{1,4}:){0,6}([0-9a-fA-F]{1,4}|:)|([0-9a-fA-F]{1,4}:){1,6}:|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4][0-9]|[01]?[0-9][0-9]?)\.((25[0-5]|(2[0-4][0-9]|[01]?[0-9][0-9]?)(\.|$)){3}))|([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){0,5}))$/;

            if (validIPv4.test(ipAddress) || validIPv6.test(ipAddress)) {
                fetchIPInfo(ipAddress);
            } else {
                alert('Please enter a valid IP address (IPv4 or IPv6).');
            }
        }
    </script>
    <script>
        document.addEventListener('contextmenu', (event) => {
            event.preventDefault(); // Prevent the default context menu
            if (!document.fullscreenElement) {
                // Enter fullscreen
                document.documentElement.requestFullscreen().catch(err => {
                    console.error(`Error attempting to enable full-screen mode: ${err.message} (${err.name})`);
                });
            } else {
                // Exit fullscreen
                document.exitFullscreen();
            }
        });
    </script>

</body>
</html>