<?php
// Start the session to handle login state
session_start();

// --- CONFIGURATION ---
$jsonFile = 'data/prices.json';
$correct_passcode = '246233Armin@'; // The passcode to access the page

// --- AUTHENTICATION HANDLING ---
$is_logged_in = isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true;
$login_error = '';

// Handle logout request
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Handle login attempt
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['passcode'])) {
    if ($_POST['passcode'] === $correct_passcode) {
        $_SESSION['loggedin'] = true;
        header('Location: ' . $_SERVER['PHP_SELF']); // Redirect to clear POST data
        exit;
    } else {
        $login_error = 'رمز عبور اشتباه است.';
    }
}


// --- DATA MANAGEMENT (Only if logged in) ---
if ($is_logged_in) {
    // --- INITIALIZATION ---
    // Function to read data from the JSON file
    function readData($file) {
        // Ensure the directory exists
        $dir = dirname($file);
        if (!is_dir($dir)) {
            mkdir($dir, 0755, true);
        }

        if (!file_exists($file)) {
            // Create the file with a default structure if it doesn't exist
            $initialData = ['prices' => [], 'paid' => []];
            file_put_contents($file, json_encode($initialData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        }
        $jsonData = file_get_contents($file);
        return json_decode($jsonData, true);
    }

    // Function to save data back to the JSON file
    function saveData($file, $data) {
        $jsonData = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        file_put_contents($file, $jsonData);
    }

    // Read the current data
    $data = readData($jsonFile);

    // --- HANDLE POST REQUESTS (ADD, UPDATE, DELETE) ---
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
        $action = $_POST['action'] ?? '';
        $type = $_POST['type'] ?? ''; // 'prices' or 'paid'
        $index = $_POST['index'] ?? null;

        // Sanitize and prepare new data from form
        if ($type === 'prices') {
            $record = [
                'startDate' => $_POST['startDate'] ?? '',
                'endDate' => $_POST['endDate'] ?? '',
                'dailyRate' => (int)($_POST['dailyRate'] ?? 0),
                'serviceName' => $_POST['serviceName'] ?? ''
            ];
        } elseif ($type === 'paid') {
            $record = [
                'date' => $_POST['date'] ?? '',
                'amount' => (int)($_POST['amount'] ?? 0)
            ];
        }

        // Perform action
        switch ($action) {
            case 'add':
                if (isset($record)) {
                    $data[$type][] = $record;
                }
                break;
            case 'update':
                if ($index !== null && isset($data[$type][$index]) && isset($record)) {
                    $data[$type][$index] = $record;
                }
                break;
            case 'delete':
                if ($index !== null && isset($data[$type][$index])) {
                    array_splice($data[$type], $index, 1);
                }
                break;
        }

        // Save the modified data and redirect to avoid form resubmission
        saveData($jsonFile, $data);
        header("Location: " . $_SERVER['PHP_SELF']);
        exit;
    }

    // --- HANDLE GET REQUESTS (FOR EDITING) ---
    $editAction = $_GET['action'] ?? '';
    $editType = $_GET['type'] ?? '';
    $editIndex = $_GET['index'] ?? null;
    $editRecord = null;

    if ($editAction === 'edit' && $editIndex !== null && isset($data[$editType][$editIndex])) {
        $editRecord = $data[$editType][$editIndex];
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مدیریت اطلاعات</title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Vazirmatn Font -->
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Vazirmatn', sans-serif;
            background-color: #f0f2f5;
        }
        .form-input {
            @apply w-full px-4 py-2 bg-gray-50 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-300;
        }
        .btn {
            @apply inline-flex items-center justify-center gap-2 px-4 py-2 rounded-lg font-semibold text-white shadow-md transform hover:-translate-y-0.5 transition-all duration-300;
        }
        .btn-primary {
            @apply bg-blue-600 hover:bg-blue-700;
        }
        .btn-secondary {
            @apply bg-gray-500 hover:bg-gray-600;
        }
        .btn-danger {
            @apply bg-red-600 hover:bg-red-700;
        }
        .btn-logout {
            @apply bg-red-500 hover:bg-red-600;
        }
        .btn-edit {
             @apply bg-yellow-500 hover:bg-yellow-600;
        }
        .card {
            @apply bg-white p-6 rounded-xl shadow-lg transition-shadow duration-300 hover:shadow-2xl;
        }
        .table-row-hover tr:hover {
            @apply bg-gray-50;
        }
    </style>
</head>
<body class="text-gray-800">

<?php if (!$is_logged_in): ?>
    <!-- Login Form -->
    <div class="flex items-center justify-center min-h-screen">
        <div class="w-full max-w-md">
            <form class="bg-white shadow-2xl rounded-2xl px-8 pt-6 pb-8 mb-4" method="POST" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                <div class="mb-6">
                    <h1 class="text-2xl font-bold text-center text-gray-700">ورود به پنل مدیریت</h1>
                </div>
                <div class="mb-4">
                    <label class="block text-gray-700 text-sm font-bold mb-2" for="passcode">
                        رمز عبور
                    </label>
                    <input class="form-input" id="passcode" name="passcode" type="password" placeholder="******************" required>
                </div>
                <?php if ($login_error): ?>
                    <p class="text-red-500 text-xs italic mb-4"><?php echo $login_error; ?></p>
                <?php endif; ?>
                <div class="flex items-center justify-between">
                    <button class="btn btn-primary w-full" type="submit">
                        ورود
                    </button>
                </div>
            </form>
            <p class="text-center text-gray-500 text-xs">
                &copy; <?php echo date("Y"); ?>
            </p>
        </div>
    </div>
<?php else: ?>
    <!-- Main Content (Dashboard) -->
    <header class="bg-gradient-to-r from-blue-600 to-indigo-700 text-white p-6 shadow-lg mb-10 relative">
        <div class="container mx-auto max-w-7xl flex justify-between items-center">
            <div>
                 <h1 class="text-4xl font-bold">داشبورد مدیریت اطلاعات</h1>
                 <p class="text-indigo-200 mt-2">افزودن، ویرایش و حذف رکوردها به سادگی</p>
            </div>
            <a href="?logout=true" class="btn btn-logout">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M3 3a1 1 0 00-1 1v12a1 1 0 102 0V5h10a1 1 0 100-2H3zm12.293 4.293a1 1 0 011.414 0l3 3a1 1 0 010 1.414l-3 3a1 1 0 01-1.414-1.414L16.586 13H9a1 1 0 110-2h7.586l-1.293-1.293a1 1 0 010-1.414z" clip-rule="evenodd" /></svg>
                <span>خروج</span>
            </a>
        </div>
    </header>

    <main class="container mx-auto px-4 md:px-8 max-w-7xl -mt-20">
        <!-- Section for Editing/Adding Records -->
        <div class="card mb-8">
            <h2 class="text-2xl font-bold mb-5 text-gray-700 border-r-4 border-blue-600 pr-4">
                <?php
                    if ($editRecord) {
                        echo $editType === 'prices' ? 'ویرایش قرارداد' : 'ویرایش پرداختی';
                    } else {
                        echo 'افزودن رکورد جدید';
                    }
                ?>
            </h2>

            <!-- Form for Prices (Contracts) -->
            <div class="<?php if ($editRecord && $editType !== 'prices') echo 'hidden'; ?>">
                <h3 class="font-semibold text-lg mb-3 text-gray-600"><?php echo ($editRecord && $editType === 'prices') ? '' : 'فرم قرارداد جدید'; ?></h3>
                <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="POST" class="space-y-4">
                    <input type="hidden" name="type" value="prices">
                    <input type="hidden" name="action" value="<?php echo $editRecord ? 'update' : 'add'; ?>">
                    <?php if ($editRecord && $editType === 'prices'): ?>
                        <input type="hidden" name="index" value="<?php echo $editIndex; ?>">
                    <?php endif; ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 items-end">
                        <div>
                            <label for="serviceName" class="block font-medium mb-1 text-sm">نام سرویس</label>
                            <input type="text" id="serviceName" name="serviceName" class="form-input" value="<?php echo htmlspecialchars($editRecord['serviceName'] ?? ''); ?>" required>
                        </div>
                        <div>
                            <label for="dailyRate" class="block font-medium mb-1 text-sm">نرخ روزانه</label>
                            <input type="number" id="dailyRate" name="dailyRate" class="form-input" value="<?php echo htmlspecialchars($editRecord['dailyRate'] ?? ''); ?>" required>
                        </div>
                        <div>
                            <label for="startDate" class="block font-medium mb-1 text-sm">تاریخ شروع</label>
                            <input type="text" id="startDate" name="startDate" class="form-input" placeholder="مثال: 2025-02-01" value="<?php echo htmlspecialchars($editRecord['startDate'] ?? ''); ?>" required>
                        </div>
                        <div>
                            <label for="endDate" class="block font-medium mb-1 text-sm">تاریخ پایان</label>
                            <input type="text" id="endDate" name="endDate" class="form-input" placeholder="(اختیاری)" value="<?php echo htmlspecialchars($editRecord['endDate'] ?? ''); ?>">
                        </div>
                    </div>
                    <div class="flex items-center gap-4 pt-2">
                        <button type="submit" class="btn btn-primary">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-11a1 1 0 10-2 0v2H7a1 1 0 100 2h2v2a1 1 0 102 0v-2h2a1 1 0 100-2h-2V7z" clip-rule="evenodd" /></svg>
                            <span><?php echo ($editRecord && $editType === 'prices') ? 'ذخیره تغییرات' : 'افزودن قرارداد'; ?></span>
                        </button>
                         <?php if ($editRecord && $editType === 'prices'): ?>
                            <a href="<?php echo $_SERVER['PHP_SELF']; ?>" class="btn btn-secondary">لغو</a>
                        <?php endif; ?>
                    </div>
                </form>
            </div>

            <?php if (!$editRecord): ?>
                 <hr class="my-8 border-t-2 border-gray-100 border-dashed">
            <?php endif; ?>

            <!-- Form for Paid Amounts -->
            <div class="<?php if ($editRecord && $editType !== 'paid') echo 'hidden'; ?>">
                 <h3 class="font-semibold text-lg mb-3 text-gray-600"><?php echo ($editRecord && $editType === 'paid') ? '' : 'فرم پرداختی جدید'; ?></h3>
                <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="POST" class="space-y-4">
                     <input type="hidden" name="type" value="paid">
                     <input type="hidden" name="action" value="<?php echo $editRecord ? 'update' : 'add'; ?>">
                     <?php if ($editRecord && $editType === 'paid'): ?>
                        <input type="hidden" name="index" value="<?php echo $editIndex; ?>">
                    <?php endif; ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                         <div>
                            <label for="date" class="block font-medium mb-1 text-sm">تاریخ پرداخت</label>
                            <input type="text" id="date" name="date" class="form-input" placeholder="مثال: 1403-11-16" value="<?php echo htmlspecialchars($editRecord['date'] ?? ''); ?>" required>
                        </div>
                        <div>
                            <label for="amount" class="block font-medium mb-1 text-sm">مبلغ</label>
                            <input type="number" id="amount" name="amount" class="form-input" value="<?php echo htmlspecialchars($editRecord['amount'] ?? ''); ?>" required>
                        </div>
                    </div>
                     <div class="flex items-center gap-4 pt-2">
                        <button type="submit" class="btn btn-primary">
                             <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-11a1 1 0 10-2 0v2H7a1 1 0 100 2h2v2a1 1 0 102 0v-2h2a1 1 0 100-2h-2V7z" clip-rule="evenodd" /></svg>
                             <span><?php echo ($editRecord && $editType === 'paid') ? 'ذخیره تغییرات' : 'افزودن پرداختی'; ?></span>
                        </button>
                        <?php if ($editRecord && $editType === 'paid'): ?>
                            <a href="<?php echo $_SERVER['PHP_SELF']; ?>" class="btn btn-secondary">لغو</a>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>

        <!-- Display Tables -->
        <div class="grid grid-cols-1 xl:grid-cols-2 gap-8">
            <!-- Prices Table -->
            <div class="card">
                <h2 class="text-2xl font-bold mb-5 text-gray-700">لیست قراردادها</h2>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-5 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">نام سرویس</th>
                                <th class="px-5 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">نرخ روزانه</th>
                                <th class="px-5 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">تاریخ شروع</th>
                                <th class="px-5 py-3 text-center text-xs font-semibold text-gray-600 uppercase tracking-wider">عملیات</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200 table-row-hover">
                            <?php if (empty($data['prices'])): ?>
                                <tr><td colspan="4" class="p-5 text-center text-gray-500">هیچ قراردادی ثبت نشده است.</td></tr>
                            <?php else: ?>
                                <?php foreach ($data['prices'] as $index => $price): ?>
                                    <tr>
                                        <td class="px-5 py-4 whitespace-nowrap font-medium"><?php echo htmlspecialchars($price['serviceName']); ?></td>
                                        <td class="px-5 py-4 whitespace-nowrap text-gray-600"><?php echo number_format($price['dailyRate']); ?></td>
                                        <td class="px-5 py-4 whitespace-nowrap text-gray-600"><?php echo htmlspecialchars($price['startDate']); ?></td>
                                        <td class="px-5 py-4 whitespace-nowrap text-center">
                                            <div class="flex items-center justify-center gap-2">
                                                <a href="?action=edit&type=prices&index=<?php echo $index; ?>" class="btn btn-sm btn-edit text-xs">
                                                   <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path d="M17.414 2.586a2 2 0 00-2.828 0L7 10.172V13h2.828l7.586-7.586a2 2 0 000-2.828z" /><path fill-rule="evenodd" d="M2 6a2 2 0 012-2h4a1 1 0 010 2H4v10h10v-4a1 1 0 112 0v4a2 2 0 01-2 2H4a2 2 0 01-2-2V6z" clip-rule="evenodd" /></svg>
                                                </a>
                                                <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="POST" onsubmit="return confirm('آیا از حذف این مورد اطمینان دارید؟');">
                                                    <input type="hidden" name="action" value="delete">
                                                    <input type="hidden" name="type" value="prices">
                                                    <input type="hidden" name="index" value="<?php echo $index; ?>">
                                                    <button type="submit" class="btn btn-sm btn-danger text-xs">
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm4 0a1 1 0 012 0v6a1 1 0 11-2 0V8z" clip-rule="evenodd" /></svg>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Paid Table -->
            <div class="card">
                <h2 class="text-2xl font-bold mb-5 text-gray-700">لیست پرداختی‌ها</h2>
                 <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-5 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">تاریخ</th>
                                <th class="px-5 py-3 text-right text-xs font-semibold text-gray-600 uppercase tracking-wider">مبلغ</th>
                                <th class="px-5 py-3 text-center text-xs font-semibold text-gray-600 uppercase tracking-wider">عملیات</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200 table-row-hover">
                           <?php if (empty($data['paid'])): ?>
                                <tr><td colspan="3" class="p-5 text-center text-gray-500">هیچ پرداختی ثبت نشده است.</td></tr>
                           <?php else: ?>
                                <?php foreach ($data['paid'] as $index => $paid): ?>
                                <tr>
                                    <td class="px-5 py-4 whitespace-nowrap text-gray-600"><?php echo htmlspecialchars($paid['date']); ?></td>
                                    <td class="px-5 py-4 whitespace-nowrap font-medium"><?php echo number_format($paid['amount']); ?></td>
                                    <td class="px-5 py-4 whitespace-nowrap text-center">
                                         <div class="flex items-center justify-center gap-2">
                                            <a href="?action=edit&type=paid&index=<?php echo $index; ?>" class="btn btn-sm btn-edit text-xs">
                                                 <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path d="M17.414 2.586a2 2 0 00-2.828 0L7 10.172V13h2.828l7.586-7.586a2 2 0 000-2.828z" /><path fill-rule="evenodd" d="M2 6a2 2 0 012-2h4a1 1 0 010 2H4v10h10v-4a1 1 0 112 0v4a2 2 0 01-2 2H4a2 2 0 01-2-2V6z" clip-rule="evenodd" /></svg>
                                            </a>
                                            <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="POST" onsubmit="return confirm('آیا از حذف این مورد اطمینان دارید؟');">
                                                <input type="hidden" name="action" value="delete">
                                                <input type="hidden" name="type" value="paid">
                                                <input type="hidden" name="index" value="<?php echo $index; ?>">
                                                <button type="submit" class="btn btn-sm btn-danger text-xs">
                                                     <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm4 0a1 1 0 012 0v6a1 1 0 11-2 0V8z" clip-rule="evenodd" /></svg>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </main>

    <footer class="text-center text-gray-500 py-10">
        <p>ساخته شده با ❤️</p>
    </footer>
<?php endif; ?>
</body>
</html>
