<?php
session_start();

// Define the correct password
$correct_password = '212121';

// Generate two random numbers for the CAPTCHA
if (!isset($_SESSION['captcha_num1'])) {
    $_SESSION['captcha_num1'] = rand(4, 9);
    $_SESSION['captcha_num2'] = rand(6, 9);
}

// Check if the form has been submitted
if (isset($_POST['password'])) {
    // Check if the entered password is correct and CAPTCHA is correct
    $captcha_sum = $_SESSION['captcha_num1'] + $_SESSION['captcha_num2'];
    if ($_POST['password'] === $correct_password && (int)$_POST['captcha'] === $captcha_sum) {
        // Set a session variable to indicate access is granted
        $_SESSION['access_granted'] = true;
    } else {
        // Set an error message
        $error_message = 'رمز ورود یا پاسخ کد امنیتی اشتباه است';
        // Do not unset CAPTCHA so it remains visible
        // Optionally, reset CAPTCHA after a certain number of attempts
    }
}

// Check if access has been granted
if (!isset($_SESSION['access_granted'])) {
    // Display the password form
    ?>
    <!DOCTYPE html>
    <html lang="fa">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, viewport-fit=cover">
        <title>مصطفی  </title>
        <link rel="stylesheet" href="data/style.css">
        <style>
            .error {
                color: red;
                margin: 10px;
                font-size:12px;
            }
        </style>
        
    </head>
    
    <body>
        <div class="bg-image"></div>
        <div class="passform">  
            <h1 style="color:#fff;">مصطفی </h1>
            <br>
            <h4 style="color:#fff;">لطفا رمز خود را وارد کنید</h4>

            <form action="index.php" method="post">
                <label for="password"></label>
                <input type="password" name="password" class="input" inputmode="numeric" maxlength="6" placeholder="_ _ _ _ _ _" required><br><br>
                
                <?php if (isset($_SESSION['captcha_num1']) && isset($_SESSION['captcha_num2'])): ?>
                    <label style="color:#fff;" for="captcha">جمع کنید <br><?php echo $_SESSION['captcha_num1'] . ' + ' . $_SESSION['captcha_num2']; ?> = ?</label><br>
                    <input inputmode="numeric" maxlength="2" placeholder="_ _" type="text" name="captcha" class="input" required><br><br>
                <?php endif; ?>
                
                     <?php if (isset($error_message)) { ?>
                        <div class="error"><?php echo $error_message; ?></div>
                    <?php } ?>
                    
                <input class="button" type="submit" value="ورود">
            </form>
        </div>
        
    </body>
    </html>
    
<?php
    exit; // Stop executing the rest of the script
}

// If access is granted, display the protected content
?>

<?php
// Function to get the real user IP address
function getUserIP() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        return $_SERVER['HTTP_CF_CONNECTING_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ipList = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        return trim($ipList[0]);
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

// Set the path for the log file
$logFile = 'data/visitor_log.json';

// Get the user's IP address
$ipAddress = getUserIP();

// Get the user agent (browser/device information)
$userAgent = $_SERVER['HTTP_USER_AGENT'];

// Get the current date and time and modify it
$dateTime = new DateTime();
$dateTime->modify('-4 hours -30 minutes');
$formattedDateTime = $dateTime->format('Y-m-d H:i:s');

// Create an array with the visitor information
$visitorData = [
    'ip_address' => $ipAddress,
    'user_agent' => $userAgent,
    'date_time' => $formattedDateTime,
];

// Check if the log file exists and read its content
if (file_exists($logFile)) {
    $currentData = json_decode(file_get_contents($logFile), true);
} else {
    $currentData = [];
}

// Append the new visitor data to the current data
$currentData[] = $visitorData;

// Write the updated data back to the JSON file
file_put_contents($logFile, json_encode($currentData, JSON_PRETTY_PRINT));

?>

<?php
// Load prices and paid data from JSON file
$jsonData = file_get_contents('data/prices.json');
$data = json_decode($jsonData, true);

// Function to calculate price based on start date, end date, and daily rate
function calculatePrice($startDate, $endDate, $dailyRate) {
    $start = new DateTime($startDate, new DateTimeZone('Asia/Tehran')); // Set timezone
    $end = new DateTime($endDate, new DateTimeZone('Asia/Tehran')); // Set timezone

    // If end date is not set, use today's date with timezone
    if (!$endDate) {
        $end = new DateTime('now', new DateTimeZone('Asia/Tehran')); // Set end date to today if not provided
    }

    // Calculate the number of days between start and end dates
    $countingDays = max(0, ceil(($end->getTimestamp() - $start->getTimestamp()) / (60 * 60 * 24)));
    $price = $countingDays * $dailyRate;

    return [
        'price' => $price,
        'days' => $countingDays
    ];
}

// Process prices
$prices = [];
$totalPrice = 0;

foreach ($data['prices'] as $item) {
    $priceInfo = calculatePrice($item['startDate'], $item['endDate'] ?? null, $item['dailyRate']);
    $priceInfo['serviceName'] = $item['serviceName'];
    $priceInfo['startDate'] = ($item['startDate']); 
    $prices[] = $priceInfo;
    $totalPrice += $priceInfo['price'];
}

// Process paid amounts
$paidData = $data['paid'];
$totalPaid = 0;

foreach ($paidData as $payment) {
    $totalPaid += $payment['amount'];
}

// Calculate the difference
$difference = $totalPrice - $totalPaid;

// Function to format numbers for Farsi
function formatFarsi($number) {
    return number_format($number);
}

// Display the results in a table
?>

<!DOCTYPE html>
<html lang="fa-IR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, viewport-fit=cover">
  <title>صورتحساب - مصطفی </title>
  <link rel="stylesheet" href="data/style.css">
  <link rel="apple-touch-icon" sizes="180x180" href="favicon/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="favicon/favicon-32x32.png">
  <script src="data/persian-date.min.js"></script>  
  <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    <style>
        #emoji {
            position: absolute;
            font-size: 50px;
            display: none;
        }
    </style>
</head>
    
<body onclick="closeModal('myModal')">
    
<div class="card" style="display: grid;height: auto;padding: 15px;min-height: 50vh;width: 80%;border-radius: 50px;direction:rtl;">
    <div style="font-size: 30px;color: #fff;position: relative;">مصطفی </div>
    <div id="dateContainer"  class="dateContainer"></div>
<div class="iconsstyle">
<div href="#" onclick="showModal('modal1')" class="icons"> <img src="data/receipt.svg" class="scale" > <a>صورتحساب</a> </div>
<div href="#" onclick="showModal('modal2')" class="icons"> <img src="data/paid.svg" class="scale" ><a >پرداختی ها</a> </div>
<div href="#" onclick="showModal('modal3')" class="icons"> <img src="data/contract.svg" class="scale" > <a >قراردادها </a> </div>
</div>
<a id="downloadLink" href="#" style="font-size: 8px;;margin: auto;margin-top:20px"> دانلود PDF صورتحساب</a>
</div>
<div id="modal1" class="modal">
        <span onclick="closeModal('modal1')" class="close">&times;</span>
        <div class="card" style="direction: rtl;margin-top: -50px">
    <h1>صورتحساب</h1>
    <div>
        
       <table border="1" cellpadding="1" id="tbl">
         <thead>
            <tr style="background-color:#0000005e">
                <th>سرویس</th>
                <th>تاریخ شروع / پایان</th> 
                <th> مدت </th>
                <th>هزینه کرد (تومان)</th>
            </tr>
        </thead>
        <tbody>
         <?php foreach ($data['prices'] as $item): ?>
                 <tr>
                <td data-label="Service Name"><?php echo htmlspecialchars($item['serviceName']); ?></td>
                <td data-label="Start Date"><?php echo htmlspecialchars($item['startDate']); ?> • <?php echo htmlspecialchars($item['endDate']); ?></td>
                <td data-label="Days"><?php echo htmlspecialchars(calculatePrice($item['startDate'], $item['endDate'] ?? null, $item['dailyRate'])['days']); ?> روز</td>
                <td data-label="Price"><?php echo formatFarsi(calculatePrice($item['startDate'], $item['endDate'] ?? null, $item['dailyRate'])['price']); ?></td>
            </tr>
        <?php endforeach; ?>

            <tr style="background-color:#0000005e">
                <td style="font-weight: bold; color: #fff;" colspan="2">جمع کل</td>
                <td style="font-weight: bold; color: #fff;" colspan="2"><?= formatFarsi($totalPrice) ?> تومان</td>
            </tr>
            <tr style="background-color:#0000005e">
                <td style="font-weight: bold; color: #fff;" colspan="2">جمع پرداختی</td>
                <td style="font-weight: bold; color: #fff;" colspan="2"><?= formatFarsi($totalPaid) ?> تومان</td>
            </tr>
            <tr style="background-color:#0000005e">
                <td style="font-weight: bold; color: #fff;" colspan="2">اختلاف حساب</td>
                <td style="font-weight: bold; color: <?= $difference > 0 ? 'red' : ($difference < 0 ? 'green' : 'black') ?>;" colspan="2">
                    <?= formatFarsi($difference) ?> تومان
                </td>
            </tr>
        </tbody>
    </table>
        
    </div>
			<p style="font-size:9px;color:#fff;">
			•آپدیت هزینه ها بصورت روزانه و خودکار میباشد• </p>
</div>
    
</div>

<div id="modal2" class="modal">
        <span onclick="closeModal('modal2')" class="close">&times;</span>
       <div class="card" style="margin-top: -50px;">
    <h1>پرداختی ها</h1>
 <table border="1" cellpadding="1" id="tbl2" style="width: 80%;margin: auto;direction:rtl;">
        <thead>
            <tr style="background-color:#0000005e">
                <th>تاریخ</th>
                <th>مقدار (تومان)</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($paidData as $payment): ?>
                <tr>
                    <td><?= htmlspecialchars($payment['date']) ?></td>
                    <td><?= formatFarsi($payment['amount']) ?></td>
                </tr>
            <?php endforeach; ?>
            <tr class="total" style="background-color:#0000005e">
                <td style="font-weight: bold; color: #fff;">جمع کل پرداختی</td>
                 <td style="font-weight: bold; color: #fff;"><?= formatFarsi($totalPaid) ?> </td>
            </tr>
        </tbody>
    </table>
</div>

</div>

<div id="modal3" class="modal">
        <span onclick="closeModal('modal3')" class="close">&times;</span>
        <div class="card contract" style="direction:rtl;margin-top: -50px;">
  <h1>
    قراردادها 
  </h1>
  
  
 <table border="1" cellpadding="1" id="tbl2" >
    <thead>
        <tr style="background-color:#0000005e">
            <th>شماره</th>
            <th>متن</th>
        </tr>
    </thead>
    <tbody>
         <tr>
            <td>قرارداد ۱ </td>
            <td>طبق صورتحساب</td>
        </tr>
    </tbody>
</table>
<br><br>


</div>     
</div>

<button class="button" style="font-size: 10px;width: 80px;/*! position: absolute; */bottom: 20px;margin:0px auto;border-radius: 10px;padding: 5px;" onclick="window.location.href='logout.php';"> خــــــــــروج </button>
<div id="emoji">💎</div>
<div class="bg-image"> </div>
<!-- partial -->


  <script>
    // add script to header persian-date.min.js
    var dateContainer = document.getElementById('dateContainer');
    // Get the current Gregorian date
    var gregorianDate = new Date();
    // Convert the Gregorian date to the Persian (Shamsi) calendar
    var persianDate = new persianDate(gregorianDate);
    // Display the formatted Persian date
    dateContainer.textContent = persianDate.format('dddd، D MMMM YYYY');
  </script>
  
    <script>
        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
    
                const target = document.querySelector(this.getAttribute('href'));
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            });
        });
    </script>
    
<script>
document.addEventListener("DOMContentLoaded", function () {
    const downloadLink = document.getElementById('downloadLink');

    downloadLink.addEventListener("click", function (event) {
        event.preventDefault(); // Prevent the default anchor behavior

        const element1 = document.getElementById('tbl');
        const element2 = document.getElementById('tbl2');

        // Create a clone of the tables to apply PDF styles
        const clone = document.createElement('div');
        clone.appendChild(element1.cloneNode(true));
        
        // Add a spacer
        const spacer = document.createElement('div');
        spacer.style.margin = "40px 0"; // Adjust the margin as needed
        clone.appendChild(spacer);

        clone.appendChild(element2.cloneNode(true));

        const pdfStyle = document.createElement('style');
        pdfStyle.innerHTML = `
            table {
                width: 70%;
                border-collapse: collapse;
                background-color: white; /* White background for PDF */
                color: black; /* Black text for PDF */
                direction: rtl;
                text-shadow: none;
                margin-left:auto;
                 margin-right:auto;
            }
            th, td, tr {
                border: 1px solid black; /* Black borders for PDF */
                padding: 8px;
                background-color: white; /* White background for PDF */
                color: black !important; /* Black text for PDF */
                text-shadow: none;
                font-size:16px;
            }
        `;
        clone.appendChild(pdfStyle);

        // PDF options
        const pdfOptions = {
            margin:       10,        // Set margins
            filename:     'invoice.pdf', // The name of the PDF file
            image:        { type: 'jpeg', quality: 0.68 }, // Image options
            html2canvas:  { scale: 2, useCORS: true }, // Scale for rendering
            jsPDF:        { unit: 'mm', format: 'a3', orientation: 'portrait' } // PDF format and orientation
        };

        // Use a timeout to ensure rendering is complete
        setTimeout(() => {
            html2pdf()
                .from(clone)
                .set(pdfOptions) // Apply the options
                .save();
        }, 100); // Adjust the delay if necessary
    });
});
</script>

       	<script>
        document.addEventListener("DOMContentLoaded", function() {
            convertToPersianNumbers();
        });

        function convertToPersianNumbers() {
            var elements = document.getElementsByTagName("*");
            var persianDigits = ["۰", "۱", "۲", "۳", "۴", "۵", "۶", "۷", "۸", "۹"];

            for (var i = 0; i < elements.length; i++) {
                var element = elements[i];
                if (element.childNodes.length === 1 && element.childNodes[0].nodeType === 3) {
                    element.innerHTML = element.innerHTML.replace(/\d/g, function(match) {
                        return persianDigits[parseInt(match)];
                    });
                }
            }
        }
    </script>
<script>
function showModal(modalId) {
    // Hide all modals
    const modals = document.querySelectorAll('.modal');
    modals.forEach(modal => {
        modal.style.display = 'none';
    });

    // Show the selected modal
    const modalToShow = document.getElementById(modalId);
    if (modalToShow) {
        modalToShow.style.display = 'block';
    }
}

function closeModal(modalId) {
    const modalToClose = document.getElementById(modalId);
    if (modalToClose) {
        modalToClose.style.display = 'none';
    }
}

// Close modal when clicking outside of it
window.onclick = function(event) {
    const modals = document.querySelectorAll('.modal');
    modals.forEach(modal => {
        // Check if the click is outside the modal content
        if (event.target == modal) {
            closeModal(modal.id);
        }
    });
}

// Optional: Close modal with the ESC key
window.addEventListener('keydown', function(event) {
    if (event.key === "Escape") {
        const modals = document.querySelectorAll('.modal');
        modals.forEach(modal => {
            closeModal(modal.id);
        });
    }
});
</script>
<script>
    document.addEventListener('contextmenu', function(event) {
        event.preventDefault(); // Prevent the default context menu and show custom right click

        const emoji = document.getElementById('emoji');
        emoji.style.left = event.pageX + 'px';
        emoji.style.top = event.pageY + 'px';
        emoji.style.display = 'block';

        // Hide the emoji after seconds
        setTimeout(() => {
            emoji.style.display = 'none';
        }, 2000);
    });
</script>
</body>
</html>
