<?php
session_start();

// Define the correct password
$correct_password = '246233';

// Check if the form has been submitted
if (isset($_POST['password'])) {
    if ($_POST['password'] === $correct_password) {
        $_SESSION['access_granted'] = true;
    } else {
        $error_message = 'Incorrect password. Please try again.';
    }
}

if (!isset($_SESSION['access_granted'])) {
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Password Protected Page</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                display: flex;
                justify-content: center;
                align-items: center;
                height: 100vh;
                background-color: #1a1a1a;
                color: #f0f0f0;
            }
            form {
                background: #2a2a2a;
                padding: 20px;
                border-radius: 5px;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.5);
            }
            input {
                padding: 10px;
                margin-bottom: 10px;
                width: 100%;
                box-sizing: border-box;
                background: #333;
                color: #f0f0f0;
                border: 1px solid #444;
            }
            input[type="password"], input[type="submit"] {
                width: 100%;
            }
            input[type="submit"] {
                background-color: #007BFF;
                color: white;
                border: none;
                border-radius: 5px;
                cursor: pointer;
            }
            input[type="submit"]:hover {
                background-color: #0056b3;
            }
            .error {
                color: red;
            }
        </style>
    </head>
    <body>
        <form method="post">
            <h2>Enter Password</h2>
            <?php if (isset($error_message)) { ?>
                <div class="error"><?php echo $error_message; ?></div>
            <?php } ?>
            <input type="password" name="password" required>
            <input type="submit" value="Submit">
        </form>
    </body>
    </html>
    <?php
    exit;
}

$jsonFile = 'data/visitor_log.json';
$jsonData = file_get_contents($jsonFile);
$visitors = json_decode($jsonData, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    die('Error parsing JSON: ' . json_last_error_msg());
}

function randomColor() {
    return sprintf('#%06X', mt_rand(0, 0xFFFFFF));
}

$ipColors = [];
foreach ($visitors as $visitor) {
    if (!isset($ipColors[$visitor['ip_address']])) {
        $ipColors[$visitor['ip_address']] = randomColor();
    }
}

// Store IP colors in cookies
setcookie('ipColors', json_encode($ipColors), time() + (86400 * 30)); // 30 days

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Visitor Log</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #1a1a1a;
            color: #f0f0f0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background-color: #2a2a2a;
        }
        th, td {
            border: 1px solid #444;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #333;
        }
        @media (max-width: 600px) {
            table, thead, tbody, th, td, tr {
                display: block;
            }
            th {
                display: none;
            }
            td {
                text-align: right;
                position: relative;
                padding-left: 50%;
            }
            td::before {
                content: attr(data-label);
                position: absolute;
                left: 10px;
                width: 45%;
                padding-left: 10px;
                text-align: left;
                font-weight: bold;
            }
        }
    </style>
    <script>
        let ascending = true;

        function sortTable(columnIndex) {
            const table = document.getElementById("visitorTable");
            const rows = Array.from(table.rows).slice(1); // Ignore the header row

            rows.sort((a, b) => {
                const cellA = a.cells[columnIndex].innerText;
                const cellB = b.cells[columnIndex].innerText;

                if (columnIndex === 0) { // IP Address
                    return ascending ? cellA.localeCompare(cellB) : cellB.localeCompare(cellA);
                } else if (columnIndex === 1) { // Date & Time
                    return ascending ? new Date(cellA) - new Date(cellB) : new Date(cellB) - new Date(cellA);
                }
                return 0;
            });

            rows.forEach(row => table.appendChild(row)); // Append sorted rows
            ascending = !ascending; // Toggle sorting order
        }
    </script>
</head>
<body>

<h1>Visitor Log</h1>

<table id="visitorTable">
    <thead>
        <tr>
            <th onclick="sortTable(0)">IP Address</th>
            <th onclick="sortTable(1)">Date & Time</th>
            <th>User Agent</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($visitors as $visitor): ?>
        <tr>
            <td data-label="IP Address" style="background-color: <?php echo $ipColors[$visitor['ip_address']]; ?>;"><?php echo htmlspecialchars($visitor['ip_address']); ?></td>
            <td data-label="Date & Time"><?php echo htmlspecialchars($visitor['date_time']); ?></td>
            <td data-label="User Agent"><?php echo htmlspecialchars($visitor['user_agent']); ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<button class="button" style="margin-top: 50px; margin-bottom: 50px; width: 50%; max-width: 300px; background-color: #007BFF; color: white; border: none; border-radius: 5px; cursor: pointer;" onclick="window.location.href='logout.php';"> خــــــــــروج </button>
</body>
</html>